clear all
set matsize 10000
set maxvar 10000
set more off

cd "\IRI data"
	
*** Program to estimate price response for 20 rarely missing UPCs

	use saltsnck_select.dta, replace
	replace upc = upc + 30
	append using carbbev_select.dta	
	replace upc = upc + 30
	append using peanbutr_select.dta	
	replace upc = upc + 30
	append using margbutr_select.dta

	compress
	
** Setup

	gen nonmiss = (logp~=.)
	by upc, sort: egen mean = mean(nonmiss)
	
	keep if mean > .96
	
	drop wm_lt5
	gen wm_lt5 = wm_1+wm_3+wm_5
	
** Results
	cd "\Results"


	reghdfe logp enter wm_1-wm_11 c.(c.weekid##c.weekid)#i.(mkt upc treat_nwm) if mean > .9695, a(weekid id) cluster(stores) keepsing
		outreg2 using final_20nonmissing, excel replace
	reghdfe logp enter wm_lt5 c.(c.weekid##c.weekid)#i.(mkt upc treat_nwm) if mean > .9695, a(weekid id) cluster(stores) keepsing
		outreg2 using final_20nonmissing, excel

	